/**
* \file: configuration_defaults.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_CONTROL_CONFIGURATION_DEFAULTS_H
#define ALD_CONTROL_CONFIGURATION_DEFAULTS_H

#ifndef ALD_CONFIG_BASE
#define ALD_CONFIG_BASE "/var/lib/ald"
#endif


#include "util/logger.h"

/**
 * the default configuration file
 */
#define DEFAULT_CONF_FILE "/etc/ald.conf"

/**
 * the default log level
 */
#define DEFAULT_LOG_LEVEL LOGGER_LEVEL_INFO

/**
 * defines whether or not console logging output is enabled by default
 */
#define DEFAULT_CONSOLE_ENABLED true

/**
 * the default path to the file where the persisted state is stored in
 */
#define DEFAULT_PERSISTED_STATE_PATH ALD_CONFIG_BASE"/ald.state"

/**
 * the default root directory under which the level scripts are stored
 */
#define DEFAULT_SCRIPT_ROOT_DIR ALD_CONFIG_BASE

/**
 * the default path to the signature data base
 */
#define DEFAULT_SIGNATURE_DB_PATH ALD_CONFIG_BASE"/ald.db"

/**
 * the default path to the signature data base
 */
#define DEFAULT_SIGNATURE_DB_PUB_KEY_PATH ALD_CONFIG_BASE"/ald.db"

/**
 * the default challenge timeout in ms
 */
#define DEFAULT_CHALLENGE_TIMEOUT 5000

/**
 * the default Script execution timeout in ms
 */
#define DEFAULT_SCRIPT_EXEC_TIMEOUT 15000

/**
 * the default path to a file that triggers a level change replay
 */
#define DEFAULT_REPLAY_LEVEL_TRIGGER_PATH ALD_CONFIG_BASE"/replay_level.trigger"

/**
 * the default path to a file that marks level change completion
 */
#define DEFAULT_LEVEL_CHANGE_COMPLETE_FILE_PATH ALD_CONFIG_BASE"/level_change_complete"

/**
 * the default value to response challenge verification key behaviour
 */
#define DEFAULT_CHALLENGE_VERIFY_KEY_BEHAVIOR UNLOCK_THAT_AND_BELOW_LEVELS

/**
 *  The default ALD level
 */
#define DEFAULT_ALD_LEVEL 50

/**
 * The default private key's destination directory
 */
#define DEFAULT_PRIVKEY_DEST_DIR "."
#endif
